/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui;

import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;

public class StatusDisplayPanel
extends SCTPanel
implements Runnable {
    private JLabel m_dateButton;
    private JLabel m_timeButton;
    private JLabel m_iconButton;
    private JLabel[] m_attributes = new JLabel[4];

    public StatusDisplayPanel() {
        this.setColor1(SCTConstants.qdiLtGray);
        this.setColor2(SCTConstants.qdiLtGray);
        this.initContent();
        this.initializeGUI();
        new Thread(this).start();
    }

    private void initContent() {
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        this.m_dateButton = new JLabel(string);
        this.m_dateButton.setFont(new Font("Serif", 0, 10));
        this.m_dateButton.setBackground(Color.white);
        this.m_dateButton.setHorizontalAlignment(0);
        Date date2 = new Date();
        String string2 = DateFormat.getTimeInstance().format(date2);
        this.m_timeButton = new JLabel(string2);
        this.m_timeButton.setFont(new Font("Serif", 0, 10));
        this.m_timeButton.setBackground(Color.white);
        this.m_timeButton.setHorizontalAlignment(0);
        this.m_iconButton = new JLabel();
        this.m_iconButton.setBackground(Color.white);
        this.m_iconButton.setHorizontalAlignment(0);
        this.m_attributes[0] = new JLabel("No product selected");
        this.m_attributes[1] = new JLabel("No CDF selected");
        this.m_attributes[2] = new JLabel("No device selected");
        this.m_attributes[3] = new JLabel("Host not connected");
        for (int i = 0; i < 4; ++i) {
            this.m_attributes[i].setFont(new Font("Serif", 0, 10));
            this.m_attributes[i].setBackground(Color.white);
            this.m_attributes[i].setForeground(Color.red);
            this.m_attributes[i].setHorizontalAlignment(0);
        }
    }

    public void setAttribute(int n, String string) {
        this.m_attributes[n].setForeground(Color.black);
        this.m_attributes[n].setText(string);
    }

    private void initializeGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.setLayout(gridBagLayout);
        this.setBackground(new Color(228, 228, 228));
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.m_dateButton, gridBagConstraints);
        this.add(this.m_dateButton);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.m_timeButton, gridBagConstraints);
        for (int i = 0; i < 4; ++i) {
            gridBagConstraints.ipadx = 20;
            gridBagConstraints.gridx = i + 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.m_attributes[i], gridBagConstraints);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_dateButton || actionEvent.getSource() == this.m_timeButton || actionEvent.getSource() == this.m_iconButton) {
            // empty if block
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Date date = new Date();
            String string = DateFormat.getTimeInstance().format(date);
            this.m_timeButton.setText(string);
        }
    }
}

